% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsnImportGenericPathways.R
\name{gsnImportGenericPathways}
\alias{gsnImportGenericPathways}
\title{gsnImportGenericPathways}
\usage{
gsnImportGenericPathways(
  object,
  pathways_data = NULL,
  filename = NULL,
  type = "generic",
  id_col = NULL,
  stat_col = NULL,
  stat_col_2 = NULL,
  sig_order = NULL,
  sig_order_2 = NULL,
  n_col = NULL,
  sep = "\\t"
)
}
\arguments{
\item{object}{A GSNData object.}

\item{pathways_data}{An (optional) data.frame containing the pathways analysis. (Either this or the
\code{filename} argument must be set.}

\item{filename}{An (optional) filename for data sets read from a text file containing pathways results. This is ignored
if the \code{pathways_data} argument is set.}

\item{type}{A character vector of length 1 indicating the type of result set. This defaults to \code{'generic'}.}

\item{id_col}{(optional) A character vector of length 1 indicating the name of the column used as a key for gene
sets or modules. This should be the same as the set of names of gene sets in the gene set collection specified by the
\code{geneSetCollection} argument used in building gene set networks. If not specified, the function will search for
\code{"ID"}, \code{"id"}, \code{"NAME"} & \code{"Term"} in the data set's column names, in that order, taking the first
one it finds. The values in the column must correspond to the names of the gene sets provided, or an error will be thrown.}

\item{stat_col}{(optional) A character vector of length 1 indicating the name of the column used as a statistic
to evaluate the quality of pathways results. If unspecified, the function uses regular expressions to search for
a column that is labeled as a p-value or p-adj.}

\item{stat_col_2}{(optional) A character vector of length 1 indicating the name of the column used as an optional
second statistic to evaluate the quality of pathways results. If unspecified, the value is NULL.}

\item{sig_order}{(optional) Either \code{'loToHi'} (default) or \code{'hiToLo'} depending on the statistic used to
evaluate pathways results.}

\item{sig_order_2}{(optional) Either \code{'loToHi'} (default) or \code{'hiToLo'} depending on the \code{stat_col_2}
statistic used to evaluate pathways results.}

\item{n_col}{(optional) The name of a pathways data column that contains gene set size information. If unset, the
function will scan for the strings \code{'N1'}, \code{'N'}, \code{'SIZE'}, and \code{'Count'}, taking the fist one it finds.}

\item{sep}{A separator for text file import, defaults to "\\t". Ignored if the \code{filename} argument is not specified.}
}
\value{
This returns a GSNData object containing imported pathways data.

Note: An error is thrown if all gene set IDs in the \code{$genePresenceAbsence} field are not present in the GSNORA ID
column. On the other hand, if there are gene set IDs present in the pathways data that are absent from the
genePresenceAbsence matrix, then these methods emit a warning. It also checks for the standard GSNORA data set column
names, and if some are missing, it will throw an error.
}
\description{
Import a data.frame or text file containing a pathways result set to a GSNData object.
The \code{id_col} and \code{stat_col} should be specified, but if they are not, the function attempts to guess.
}
\examples{

library(GSNA)

# In this example, we generate a gene set network from CERNO example
# data. We begin by subsetting the CERNO data for significant results:
sig_pathways.cerno <- subset( Bai_CiHep_DN.cerno, adj.P.Val <= 0.05 )

# Now create a gene set collection containing just the gene sets
# with significant CERNO results, by subsetting Bai_gsc.tmod using
# the gene set IDs as keys:
sig_pathways.tmod <- Bai_gsc.tmod[sig_pathways.cerno$ID]

# And obtain a background gene set from differential expression data:
background_genes <- toupper( rownames( Bai_CiHep_v_Fib2.de ) )

# Build a gene set network:
sig_pathways.GSN <-
   buildGeneSetNetworkJaccard(geneSetCollection = sig_pathways.tmod,
                              ref.background = background_genes )

# Now import the CERNO data. Generic import can work with most types of data,
# and we can manually specify id_col, stat_col, n_col:
sig_pathways.GSN <- gsnImportGenericPathways( sig_pathways.GSN,
                                              pathways_data = sig_pathways.cerno,
                                              id_col = 'ID',
                                              stat_col = 'adj.P.Val',
                                              sig_order = 'loToHi',
                                              n_col = 'N1'
                                               )

}
\seealso{
\code{\link{gsnAddPathwaysData}}
\code{\link{gsnImportCERNO}}
\code{\link{gsnImportGSEA}}
\code{\link{gsnImportGenericPathways}}
}
