% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_station_list.R
\name{update_station_list}
\alias{update_station_list}
\title{Download the latest station list from the NCEI server and update internal database}
\usage{
update_station_list()
}
\description{
This function downloads the latest station list (isd-history.csv) from the
NCEI FTP server and updates the data distributed with \code{GSODR} so that
you have the latest list of stations available.  These data provide unique
identifiers, country, state (if in US), latitude, longitude, elevation and
when weather observations begin and end.  Stations with invalid latitude and
longitude values will not be included.
}
\details{
Care should be taken when using this function if reproducibility is necessary
as different machines with the same version of \code{GSODR} can end up with
different versions of the isd_history.csv file internally.

There is no need to use this unless you know that a station exists in the
GSODR data that is not available in the database distributed with
\code{\link{GSODR}}.
}
\examples{
\dontrun{
update_station_list()
}

}
\author{
Adam H Sparks, \email{adamhsparks@gmail.com}
}
