% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hubs.R
\name{get_hubs}
\alias{get_hubs}
\title{Identify Transit Hubs}
\usage{
get_hubs(gtfs)
}
\arguments{
\item{gtfs}{A GTFS object, preferably of class `wizardgtfs`. If not, the function will attempt to convert it using `GTFSwizard::as_wizardgtfs()`.}
}
\value{
An `sf` object containing the following columns:
\describe{
  \item{stop_id}{The unique identifier for each stop.}
  \item{trip_id}{A list of trip IDs associated with the stop.}
  \item{route_id}{A list of unique route IDs associated with the stop.}
  \item{n_trip}{The total number of trips that pass through the stop.}
  \item{n_routes}{The total number of unique routes that pass through the stop.}
  \item{geometry}{The spatial location of the stop as an `sf` point object.}
}
}
\description{
The `get_hubs` function identifies transit hubs from a GTFS dataset by calculating the number of trips and unique routes served by each stop. It returns a spatial object with metadata for each hub, allowing for further analysis or visualization.
}
\details{
The function performs the following steps:
\enumerate{
  \item Extracts `stop_id` and `trip_id` pairs from the `stop_times` table.
  \item Joins this data with the `trips` table to associate `route_id` with each trip.
  \item Groups by `stop_id` to compute the number of trips (`n_trip`) and unique routes (`n_route`) per stop.
  \item Joins the resulting data with the spatial geometry of stops, transforming it into an `sf` object.
  \item Sorts the hubs by the number of unique routes (`n_routes`) in descending order.
}
}
\note{
The function uses `sf` for spatial data manipulation. Ensure that the GTFS dataset includes the `stop_times`, `trips`, and `stops` tables.
}
\examples{
# Identify hubs in a GTFS dataset
get_hubs(for_rail_gtfs)

}
\seealso{
[GTFSwizard::get_stops_sf()], [GTFSwizard::as_wizardgtfs()]
}
