% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw_GWPR.R
\name{bw.GWPR}
\alias{bw.GWPR}
\title{Bandwidth selection for basic GWPR}
\usage{
bw.GWPR(formula, data, index, SDF, adaptive = FALSE, p = 2, bigdata = FALSE,
               upperratio = 0.25, effect = "individual",
               model = c("pooling", "within", "random"),
               random.method = "swar", approach = c("CV","AIC"), kernel = "bisquare",
               longlat = FALSE, doParallel = FALSE, cluster.number = 2,
               human.set.range = FALSE, h.upper = NULL, h.lower = NULL)
}
\arguments{
\item{formula}{The regression formula: : Y ~ X1 + ... + Xk}

\item{data}{data.frame for the Panel data}

\item{index}{A vector for the indexes : (c("ID", "Time"))}

\item{SDF}{Spatial*DataFrame on which is based the data, with the "ID" in the index}

\item{adaptive}{If TRUE, adaptive distance bandwidth is used, otherwise, fixed distance bandwidth.}

\item{p}{The power of the Minkowski distance, default is 2, i.e. the Euclidean distance}

\item{bigdata}{TRUE or FALSE, if the dataset exceeds 40,000, we strongly recommend set it TRUE}

\item{upperratio}{Set the ratio between upper boundary of potential bandwidth range and the forthest distance of SDF, if bigdata = T. (default value: 0.25)}

\item{effect}{The effects introduced in the model, one of "individual" (default) , "time", "twoways", or "nested"}

\item{model}{Panel model transformation: (c("within", "random", "pooling"))}

\item{random.method}{Method of estimation for the variance components in the random effects model, one of "swar" (default), "amemiya", "walhus", or "nerlove"}

\item{approach}{Score used to optimize the bandwidth, c("CV", "AIC")}

\item{kernel}{bisquare: wgt = (1-(vdist/bw)^2)^2 if vdist < bw, wgt=0 otherwise (default);
gaussian: wgt = exp(-.5*(vdist/bw)^2);
exponential: wgt = exp(-vdist/bw);
tricube: wgt = (1-(vdist/bw)^3)^3 if vdist < bw, wgt=0 otherwise;
boxcar: wgt=1 if dist < bw, wgt=0 otherwise}

\item{longlat}{If TRUE, great circle distances will be calculated}

\item{doParallel}{If TRUE, "cluster": multi-process technique with the parallel package would be used.}

\item{cluster.number}{The number of the clusters that user wants to use}

\item{human.set.range}{If TRUE, the range of bandwidth selection could be set by the user}

\item{h.upper}{The lower boundary of potential bandwidth range.}

\item{h.lower}{The upper boundary of potential bandwidth range.}
}
\value{
The optimal bandwidth
}
\description{
A function for automatic bandwidth selection to calibrate a GWPR model
}
\examples{
\donttest{
data(TransAirPolCalif)
data(California)
formula.GWPR <- pm25 ~ co2_mean + Developed_Open_Space_perc + Developed_Low_Intensity_perc +
   Developed_Medium_Intensity_perc + Developed_High_Intensity_perc +
   Open_Water_perc + Woody_Wetlands_perc + Emergent_Herbaceous_Wetlands_perc +
   Deciduous_Forest_perc + Evergreen_Forest_perc + Mixed_Forest_perc +
   Shrub_perc + Grassland_perc + Pasture_perc + Cultivated_Crops_perc +
   pop_density + summer_tmmx + winter_tmmx + summer_rmax + winter_rmax

bw.CV.Fix <- bw.GWPR(formula = formula.GWPR, data = TransAirPolCalif,
                     index = c("GEOID", "year"),
                     SDF = California, adaptive = FALSE, p = 2, bigdata = FALSE,
                     effect = "individual", model = "within", approach = "CV",
                     kernel = "bisquare", longlat = FALSE)

bw.CV.Fix

bw.AIC.Fix <- bw.GWPR(formula = formula.GWPR, data = TransAirPolCalif,
                      index = c("GEOID", "year"),
                      SDF = California, adaptive = FALSE, p = 2, bigdata = FALSE,
                      effect = "individual", model = "within", approach = "AIC",
                      kernel = "bisquare", longlat = FALSE, doParallel = FALSE)
bw.AIC.Fix
}
}
\references{
Fotheringham, A. Stewart, Chris Brunsdon, and Martin Charlton. Geographically weighted regression: the analysis of spatially varying relationships. John Wiley & Sons, 2003.
}
\author{
Chao Li <chaoli0394@gmail.com> Shunsuke Managi <managi.s@gmail.com>
}
