% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/add.R
\name{add1.gw}
\alias{add1.gw}
\title{Add All Possible Single Terms to a GWRM Model}
\usage{
\method{add1}{gw}(object, scope, test = c("none", "Chisq"), k = 2,
  trace = FALSE, ...)
}
\arguments{
\item{object}{a fitted object of class inheriting from \code{"gw"}.}

\item{scope}{a formula giving the terms to be considered for adding.}

\item{test}{\code{"none"}, which considers the AIC criterion, or \code{Chisq}, which is the likelihood-ratio test.}

\item{k}{the penalty constant in AIC / Cp.}

\item{trace}{if \code{TRUE}, print out progress reports.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of class \code{"anova"} summarizing the differences in fit between the models.
}
\description{
Compute all the single terms in the scope argument that can be added to the GWRM model, fit those models and compute a table of the changes in fit.
}
\examples{
data(goals)
fit0 <- gw(goals ~ offset(log(played)), data = goals)
summary(fit0)

fit1 <- add1(fit0, ~ position)
summary(fit1)
}

