\name{GaDiFPT-package}
\alias{GaDiFPT-package}
\alias{GaDiFPT}
\docType{package}
\title{
First Passage Time Simulation for Gauss Diffusion Processes
}
\description{
We consider Gaussian Diffusion processes and smooth thresholds. After evaluating the mean of the process to check the subthreshold regimen hypothesis, the FPT density function is reconstructed; first passage times are also generated by an algorithm based on the hazard rate method and results are compared. The timestep of the simulations can iteratively be refined. User should provide the functional form for the drift and the infinitesimal variance of the considered diffusion process along with the functional form for the threshold. Example scripts for common drifts and thresholds are given.
}
\details{
\tabular{ll}{
Package: \tab GaDiFPT\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2015-01-16\cr
License: \tab GPL-2\cr
}
The \pkg{GaDiFPT} package allows to approximate efficiently the f.p.t. density for a diffusion process through a continuous time-dependent boundary. First, the coefficients of the diffusion process under consideration and the related boundary must be defined in a script built according to the structure of the examples reported in the \code{demo} folder. 
Parameters setting the initial time and state, the final time and the initial resolution are also to be given in the same script.
Then, the \code{\link{vectorsetup}} function will be used to calculate mean and covariance for the specified process. A plot of both the estimated mean of the process (with confidence interval)  and the boundary is produced for the user to check the subthreshold regimen.
Thus, the function \code{\link{FPTdensity_byint}}  constructs a numerical approximation of the First Passage Time density function.
Plots of the FPT density, of the FPT distribution function and of the instantaneous firing rate are produced.
Then, the function \code{\link{FPTsimul}} generates a sample of first passage times and compares the related histogram to the approximated FPT density.
The scripts \code{\link{Wiener}} and \code{\link{OrnUhl}} in the \code{demo} folder constitute skeleton examples of use of the package for simulation of the classical Wiener and Ornstein-Uhlenbeck processes through different boundaries. More compex examples are also given in \code{\link{OrnUhlCurrent}} and \code{\link{Logistic}} scripts.
}
\author{
A. Buonocore, M. F. Carfora

Maintainer: Maria Francesca Carfora <f.carfora@iac.cnr.it>
}
\references{
Buonocore, A., Caputo, L., Pirozzi, E., and Carfora, M.F., A simple algorithm to generate firing times for {Leaky Integrate-and-Fire} neuronal model. \emph{Math Biosci Eng 11}, 1 (2014), 1--10.

Buonocore, A., Nobile, A.~G., and Ricciardi, L.M.,
A new integral equation for the evaluation of first-passage-time probability densities. \emph{Adv Appl Prob 19} (1987), 784--800.
}
\keyword{ package }

