% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OccurrenceCounts.R
\name{OccurrenceCounts}
\alias{OccurrenceCounts}
\title{Generating counts dataframe for taxa}
\usage{
OccurrenceCounts(species, Occurrence_data)
}
\arguments{
\item{species}{A vector of characters with the species name.}

\item{Occurrence_data}{A data frame object with the species name, geographical coordinates,
and type of records (G or H) for a given species}
}
\value{
This function returns a data frame object with the following columns:

\tabular{lcc}{
 species \tab Species name \cr
 totalRecords  \tab Total number of records  \cr
 hasLat  \tab Number of occurrences with latitude \cr
 hasLon  \tab Number of occurrences with longitude \cr
 totalUseful  \tab Number of occurrences with coordinates \cr
 totalGRecords  \tab Number of G occurrences \cr
 totalGUseful  \tab Number of G occurrences with coordinates \cr
 totalHRecords  \tab Number of H occurrences \cr
 totalHUseful  \tab Number of H occurrences with coordinates \cr
 }
}
\description{
This function creates a summary file counting
 the total number of G and H occurrences, including those with coordinates
}
\examples{
data(CucurbitaData)
##Obtaining species names from the data
Cucurbita_splist <- unique(CucurbitaData$species)
sp_counts <- OccurrenceCounts(Cucurbita_splist[[1]],CucurbitaData)

}
\references{
Ramirez-Villegas et al. (2010) PLOS ONE, 5(10), e13497. doi: 10.1371/journal.pone.0013497
Khoury et al. 2019) Ecological Indicators 98: 420-429. doi: 10.1016/j.ecolind.2018.11.016
}
\keyword{internal}
