\name{scan.gwaa.2D-class}
\docType{class}
\alias{scan.gwaa.2D-class}
\alias{plot, scan.gwaa.2D-method}

\title{Class "scan.gwaa.2D"}
\description{This class contains results of 2D analysis. This is 
an list object, generated by \code{\link{scan.glm.2D}} or \code{\link{scan.haplo.2D}}.
}
\section{Names}{
  \item{snpnames}{list of names of SNPs tested}
  \item{P1df}{corresponding list of P-values of allelic test for association bestween SNP and trait.
		}
  \item{Pint1df}{corresponding list of P-values of signifcance of the interactions between SNPs,
		for the allelic model 
		}
  \item{P2df}{corresponding list of P-values of genotypic test for association bestween SNP and trait
		For \code{link{scan.haplo}} and \code{link{scan.haplo.2D}} this is equal to P1df and has nothing 
		to do with the actual degrees fo freedom of the test
		}
  \item{Pint1df}{corresponding list of P-values of signifcance of the interactions between SNPs
		for the genotypic test
		}
  \item{medChi1df}{Median Chi-square for allelic test}
  \item{medChi2df}{Median Chi-square on genotypic test}
  \item{map}{list of map positions of the SNPs}
  \item{chromosome}{list of chromosomes the SNPs belong to}
  \item{formula}{which formula/function call was used to comput P-values}
  \item{family}{family of the link function / nature if the test}
  \item{idnames}{list of people used in analysis}
%\describe{}
}
%\section{Extends}{}
\section{Methods}{
  \describe{
    \item{plot}{\code{signature(object = "scan.gwaa.2D")}: 
	Plots summary of 2D scan, using lsit element P1df
	 }
  }
}
%\references{}
\author{Yurii Aulchenko}
%\note{}
\seealso{
\code{\link{scan.gwaa.2D-class}},
\code{\link{scan.glm.2D}},
\code{\link{scan.haplo.2D}},
\code{\link{plot.scan.gwaa.2D}}
}
\examples{
data(srdta)
sc <- scan.glm.2D("qt3~CRSNP",data=srdta,snps=c(1:10))
class(sc)
sc$P1df
sc$P2df
sc
plot(sc)
}
\keyword{classes}

