% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstHMMGen.R
\name{EstHMMGen}
\alias{EstHMMGen}
\title{Estimation of univariate hidden Markov model}
\usage{
EstHMMGen(
  y,
  ZI = 0,
  reg,
  family,
  start = 0,
  max_iter = 10000,
  eps = 1e-04,
  size = 0,
  theta0 = NULL,
  graph = FALSE
)
}
\arguments{
\item{y}{observations; (n x 1)}

\item{ZI}{1 if zero-inflated, 0 otherwise (default)}

\item{reg}{number of regimes (including zero-inflated; must be > ZI)}

\item{family}{distribution name; run the function distributions() for help}

\item{start}{starting parameters for the estimation; (1 x p)}

\item{max_iter}{maximum number of iterations of the EM algorithm; suggestion 10000}

\item{eps}{precision (stopping criteria); suggestion 0.001.}

\item{size}{additional parameter for some discrete distributions; run the command distributions() for help}

\item{theta0}{initial parameters for each regimes; (r x p), default is NULL}

\item{graph}{TRUE a graph, FALSE otherwise (default); only for continuous distributions}
}
\value{
\item{theta}{ estimated parameters; (r x p)}

\item{Q}{estimated transition matrix for the regimes; (r x r)}

\item{eta}{conditional probabilities of being in regime k at time t given observations up to time t; (n x r) }

\item{lambda}{conditional probabilities of being in regime k at time t given all observations; (n x r)}

\item{U}{matrix of Rosenblatt transforms; (n x r)}

\item{cvm}{cramer-von-Mises statistic for goodness-of-fit}

\item{W}{pseudo-observations that should be uniformly distributed under the null hypothesis}

\item{LL}{log-likelihood}

\item{nu}{stationary distribution}

\item{AIC}{Akaike information criterion}

\item{BIC}{Bayesian information criterion}

\item{CAIC}{consistent Akaike information criterion}

\item{AICcorrected}{Akaike information criterion corrected}

\item{HQC}{Hannan-Quinn information criterion}

\item{stats}{empirical means and standard deviation of each regimes using lambda}

\item{pred_l}{estimated regime using lambda}

\item{pred_e}{estimated regime using eta}

\item{runs_l}{estimated number of runs using lambda}

\item{runs_e}{estimated number of runs using eta}
}
\description{
This function estimates the parameters from a univariate hidden Markov model
}
\details{
#############################################################################
}
\examples{
family = "gaussian"
Q = matrix(c(0.8, 0.3, 0.2, 0.7), 2, 2) ;
theta = matrix(c(-1.5, 1.7, 1, 1),2,2) ;
y = SimHMMGen(theta, Q=Q, family=family,  n=100)$SimData
est = EstHMMGen(y, reg=2, family=family)






}
