% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importFA.R
\name{importFA}
\alias{importFA}
\title{Importing a Fasta File.}
\usage{
importFA(file)
}
\arguments{
\item{file}{Specifies the filename/path}
}
\value{
An object of class \code{fa} containing the sequences. The names correspond to the sequence names given in the fasta file.
}
\description{
This function imports a standard fasta file
}
\details{
This function imports a standard fasta file. Hereby, it does not matter if the identifier and sequence are alternating or not,
as the rows starting with '>' are used as identifer.

The example file was downloaded from here and was then further truncated respective transformed to fasta format:

ftp://ftp.1000genomes.ebi.ac.uk/vol1/ftp/phase3/data/HG00096/sequence_read/
}
\examples{

 # Define here the location on HDD for the example file
   fpath <- system.file("extdata","example.fasta", package="GenomicTools.fileHandler")
 # Import the example fasta file  
   fastaFile <- importFA(file=fpath)
 
}
\seealso{
print.fa, summary.fa
}
\author{
Daniel Fischer
}
