% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdfpd_export_DFP_Data.R
\name{gdfpd.export.DFP.data}
\alias{gdfpd.export.DFP.data}
\title{Export tibble to an excel or csv (zipped) file}
\usage{
gdfpd.export.DFP.data(df.reports,
  base.file.name = paste0("GetDFPData_Export_", Sys.Date()),
  type.export = "xlsx")
}
\arguments{
\item{df.reports}{Tibble with financial information (output of gdfpd.GetDFPData)}

\item{base.file.name}{The basename of excel file (make sure you dont include the file extension)}

\item{type.export}{The extension of the desired format: 'xlsx' (default) or 'csv'}
}
\value{
TRUE, if successfull (invisible)
}
\description{
Export information from gdfpd_GetDFPData() to an excel file or csv. In the csv case, all tables are exported as csv
files and zipped in a single zip file.
}
\examples{

# get example data from RData file
my.f <- system.file('extdata/Example_DFP_Report_Petrobras.RData', package = 'GetDFPData')
load(my.f)

\dontrun{ # dontrun: keep cran check time short
gdfpd.export.DFP.data(df.reports, base.file.name = 'MyExcelFile', format.data = 'wide')
}
}
