% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gld_get_lattes_data_from_zip.R
\name{gld_get_lattes_data_from_zip}
\alias{gld_get_lattes_data_from_zip}
\title{Reads zip files from Lattes}
\usage{
gld_get_lattes_data_from_zip(zip.files, field.qualis = NULL)
}
\arguments{
\item{zip.files}{A vector with location of zip files downloaded from Lattes website}

\item{field.qualis}{Area of Qualis to get Qualis journal rankings (default equals NULL). Eg. area.qualis <- 'ECONOMIA'}
}
\value{
Returns a list with two components:
 \describe{
  \item{tpesq}{A dataframe with information about researchers}
  \item{tpublic}{A dataframe with information about publications}
  \item{tsupervisions}{A dataframe with information about all supervisions}
}
}
\description{
This function reads zipped files from Lattes, giving as output a list with several dataframes
}
\examples{

\dontrun{
# get files from pkg (you can download from other researchers in lattes website)
f.in <- system.file('extdata/3262699324398819.zip', package = 'GetLattesData')

# set qualis
field.qualis = 'ECONOMIA'

# get data
l.out <- gld_get_lattes_data_from_zip(f.in, field.qualis = field.qualis )

# print it
print(l.out$tpesq)
print(l.out$tpublic.published)
}
}
