% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vislim.R
\name{vislim}
\alias{vislim}
\title{R function for computing the limit of visibility of an object given its height}
\usage{
vislim(vis.degree = 0.01667, targ.h)
}
\arguments{
\item{vis.degree}{Limit of human visual acuity (0.01667 by default).}

\item{targ.h}{Target size (=height in meters).}
}
\description{
The function allows to plot the angular size of an object (in degrees) against the distance from
the observer, and to compute at which distance from the observer the angular size of the object
hits the limit of human visual acuity (0.01667 degrees).
}
\details{
The function returns:\cr -a plot displaying the decay in angular size as function of the object's
distance from the observer; a black dot represents the distance at which the angular size hits
the limit of human visual acuity;\cr -the value (in km) of the visibility limit.
}
\examples{
# calculate the visibility limit of an object of size 6m, and store the result (20.62 km)
#in the 'limit' object
limit <- vislim(targ.h=6)

}
\keyword{vislim}
