% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bezierArrowSmpl.R
\name{bezierArrowSmpl}
\alias{bezierArrowSmpl}
\title{A simple bezier arrow}
\usage{
bezierArrowSmpl(x = c(0.2, 0.7, 0.3, 0.9), y = c(0.2, 0.2, 0.9, 0.9),
  width = 0.05, clr = "#000000", default.units = "npc", arrow = list(),
  rez = 200, align_2_axis = TRUE, name = NULL, rm_intersect = 3L,
  gp = gpar(), vp = NULL)
}
\arguments{
\item{x}{A numeric vector or unit object specifying x-locations of
    spline control points.}

\item{y}{A numeric vector or unit object specifying y-locations of
    spline control points.}

\item{width}{The width of the arrow, either a numeric single number or a unit. \strong{Note:}
The arrow does not rely on \code{lwd} but on actual width.}

\item{clr}{The color of the arrow.}

\item{default.units}{A string indicating the default units to use
    if \code{x} or \code{y}
    are only given as numeric vectors.}

\item{arrow}{This is a list with all the \strong{base} (width) and the desired
\strong{length} for the arrow. \strong{Note:} This differs from the original
\code{\link{bezierGrob}} function.}

\item{rez}{The resolution of the arrow. This specifies how many points to retrieve from the
\code{\link{gnrlBezierPoints}} function. Defaults to 200.}

\item{align_2_axis}{Indicates if the arrow should be vertically/horizontally
aligned. This is useful for instance if the arrow attaches to a box.}

\item{name}{A character identifier.}

\item{rm_intersect}{Set to 0 if you want to skip intersection removal, 1 only to remove left or
 2 to only remove right. See details for why.

 @section Remove intersections:

 When the line is wide and the arrow has a narrow curve there may appear an empty triangle due
 to polygon cancellation (two polygons within the same are cancel out). This behaviour may be
 ugly and the function therefor tries to remove these.

 \emph{Note:} it is expensive to check if there are the lineas may intersect at one point,
 remove those unexpected, and then adjust the line to the new situation so that the
 top and bottom lines match. It can also cause some unexpected behaviour why you may want to
 remove this feature if the arrow behaves erratically.}

\item{gp}{An object of class \code{gpar}, typically the output
    from a call to the function \code{gpar}.  This is basically
    a list of graphical parameter settings.}

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
\code{grid::grob} A grob of the class polygonGrob with attributes that
 correspond to the bezier points.
}
\description{
This is an alternative to the grid packages \code{\link[grid]{bezierGrob}}
with the advantage that it allows you to draw an arrow with a specific
unit width. Note, it has only a end-arrow at this point.
}
\examples{
library(grid)
grid.newpage()
arrowGrob <- bezierArrowSmpl(x = c(.1,.3,.6,.9),
                             y = c(0.2, 0.2, 0.9, 0.9))
grid.draw(arrowGrob)

}

