% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxGrobs.R
\name{distance}
\alias{distance}
\title{Get the distance between boxes}
\usage{
distance(box1, box2, type = c("vertical", "horizontal"), half = FALSE)
}
\arguments{
\item{box1}{The first boxGrob}

\item{box2}{The second boxGrob}

\item{type}{Wheter we should retrieve the vertical or horizontal difference}

\item{half}{If set to true it returns half the distance. This is convenient
when postioning boxes between eachother.}
}
\value{
a unit with \code{"mm"}
}
\description{
Retrieves the distance between two boxes as absolute \code{"mm"} units.
}
\examples{
box1 <- boxGrob("A test box", y=.8)
box2 <- boxGrob("Another test box", y=.2)
distance(box1, box2, "v")
}
