% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matern_anisotropic3D_alt}
\alias{matern_anisotropic3D_alt}
\title{Geometrically anisotropic Matern covariance function (three dimensions, alternate parameterization)}
\usage{
matern_anisotropic3D_alt(covparms, locs)
}
\arguments{
\item{covparms}{A vector with covariance parameters
in the form (variance, B11, B12, B13, B22, B23, B33, smoothness, nugget)}

\item{locs}{A matrix with \code{n} rows and \code{3} columns.
Each row of locs is a point in R^3.}
}
\value{
A matrix with \code{n} rows and \code{n} columns, with the i,j entry
containing the covariance between observations at \code{locs[i,]} and
\code{locs[j,]}.
}
\description{
From a matrix of locations and covariance parameters of the form
(variance, B11, B12, B13, B22, B23, B33, smoothness, nugget), return the square matrix of
all pairwise covariances.
}
\section{Parameterization}{

The covariance parameter vector is (variance, B11, B12, B13, B22, B23, B33, smoothness, nugget)
where B11, B12, B13, B22, B23, B33, transform the three coordinates as
\deqn{ u_1 = B11[ x_1 + B12 x_2 + B13 x_3] }
\deqn{ u_2 = B22[ x_2 + B23 x_3] }
\deqn{ u_3 = B33[ x_3 ] }
Assuming x is transformed to u and y transformed to v, the covariances are 
\deqn{ M(x,y) = \sigma^2 2^{1-\nu}/\Gamma(\nu) (|| u - v || )^\nu K_\nu(|| u - v ||) }
The nugget value \eqn{ \sigma^2 \tau^2 } is added to the diagonal of the covariance matrix.
NOTE: the nugget is \eqn{ \sigma^2 \tau^2 }, not \eqn{ \tau^2 }.
}

