% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.R
\name{EffDesign}
\alias{EffDesign}
\title{HCT design with interim monitoring for efficacy only}
\usage{
EffDesign(k, alpha, beta, delta, d1, option = "OBF", param = 4)
}
\arguments{
\item{k}{vector of time fraction for all planned looks: k=c(1/3,2/3,1) if the three planned looks will be carried out at 1/3, 2/3 and all of the total events in the experiment arm.}

\item{alpha}{type I error.}

\item{beta}{type II error.}

\item{delta}{hazard ratio: hazard of experiment group over hazard of control group.}

\item{d1}{total number of events in the historical control group.}

\item{option}{type of spending function: "OBF", "Gamma", "Rho" or "Pocock". Default is "OBF.}

\item{param}{Parameter for Gamma family or Rho family. Default value is 4.}
}
\value{
List of dataframes and vectors containing the details about the following: design of the trial which includes the number of looks and events;
details about futility and efficacy boundaries which include transformed information time at each look, cumulative beta and alpha respectively, p-values and crossing probabilities;
etam(drift parameter); d2max(maximum number of events in the experimental group); delta_used(hazard ratio used in the design).
}
\description{
The group sequential design for historical controlled survival outcome trials with efficacy boundaries only.
}
\examples{
#HCT trial design with three equally spaced looks for efficacy only using OBF spending function.
gg<-EffDesign(k=c(0.33333,0.66667,1),alpha=0.05,beta=0.1,delta=1/1.75,d1=65,option="OBF")
#HCT trial design with three unequal spaced looks using Gamma spending function with parameter -1.
gg<-EffDesign(k=c(0.5,0.75,1),alpha=0.05,beta=0.1,delta=0.5,d1=23, option="Gamma", param=1)
}
\references{
\insertRef{doi:10.1002/pst.1756}{HCTDesign}

\insertRef{doi:10.1080/10543406.2019.1684305}{HCTDesign}
}
\author{
Tushar Patni, Yimei Li, Jianrong Wu, and Arzu Onar-Thomas.
}
