#' @name candies
#' @title Sensory assessment of candies.
#'
#' @description A dataset containing 9 sensory attributes for 5 candies assessed
#' by 11 trained assessors.
#'
#' @docType data
#' @usage data(candies)
#'
#' @format A data.frame having 165 rows and 3 variables:
#' \describe{
#'   \item{assessment}{Matrix of sensory attributes}
#'   \item{assessor}{Factor of assessors}
#'   \item{candy}{Factor of candies}
#' }
#'
#' @references Luciano G, Næs T. Interpreting sensory data by combining principal
#' component analysis and analysis of variance. Food Qual Prefer. 2009;20(3):167-175.
NULL

#' @name caldana
#' @title Arabidopsis thaliana growth experiment
#'
#' @description A dataset containing 67 metabolites from plants grown under
#' different light and temperature conditions. This subset of the data contains
#' only the light effect and time effect for limited conditions, while the full
#' data also contains gene expressions.
#'
#' @docType data
#' @usage data(caldana)
#'
#' @format A data.frame having 140 rows and 3 variables:
#' \describe{
#'   \item{light}{Light levels}
#'   \item{time}{Time of measurement}
#'   \item{compound}{Metabolic compounds}
#' }
#'
#' @references Caldana C, Degenkolbe T, Cuadros-Inostroza A, Klie S, Sulpice R,
#' Leisse A, et al. High-density kinetic analysis of the metabolomic and
#' transcriptomic response of Arabidopsis to eight environmental conditions.
#' Plant J. 2011;67(5):869-884.
NULL
