% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{block.data.frame}
\alias{block.data.frame}
\title{Block-wise indexable data.frame}
\usage{
block.data.frame(X, block_inds = NULL, to.matrix = TRUE)
}
\arguments{
\item{X}{Either a single \code{data.frame} to index or a \code{list} of matrices/data.frames}

\item{block_inds}{Named \code{list} of indexes if \code{X} is a single \code{data.frame}, otherwise \code{NULL}.}

\item{to.matrix}{\code{logical} indicating if input list elements should be converted to matrices.}
}
\value{
A \code{data.frame} which can be indexed block-wise.
}
\description{
This is a convenience function for making \code{data.frame}s that are easily
indexed on a block-wise basis.
}
\examples{
# Random data
M <- matrix(rnorm(200), nrow = 10)
# .. with dimnames
dimnames(M) <- list(LETTERS[1:10], as.character(1:20))

# A named list for indexing
inds <- list(B1 = 1:10, B2 = 11:20)

X <- block.data.frame(M, inds)
str(X)

}
\seealso{
Main methods: \code{\link{asca}}, \code{\link{apca}}, \code{\link{limmpca}}, \code{\link{msca}}, \code{\link{pcanova}}, \code{\link{prc}} and \code{\link{permanova}}.
Workhorse function underpinning most methods: \code{\link{asca_fit}}.
Extraction of results and plotting: \code{\link{asca_results}}, \code{\link{asca_plots}}, \code{\link{pcanova_results}} and \code{\link{pcanova_plots}}
}
