% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO.fun.R
\name{read.undirected.graph}
\alias{read.undirected.graph}
\title{Read an undirected graph from a file}
\usage{
read.undirected.graph(file = "graph.txt.gz")
}
\arguments{
\item{file}{name of the file to be read. The extension of the file can be or plain format (".txt") or compressed (".gz").}
}
\value{
a graph of class \code{graphNEL}
}
\description{
The graph is read from a file and a \code{graphNEL} object is built. The format of the input file is a sequence of rows. 
Each row corresponds to an edge represented through a pair of vertices separated by blanks, and the weight of the edge.
}
\examples{
edges <- system.file("extdata/edges.txt.gz", package="HEMDAG");
g <- read.undirected.graph(file=edges);
}
