% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microHIMA.R
\name{microHIMA}
\alias{microHIMA}
\title{High-dimensional mediation analysis for compositional microbiome data}
\usage{
microHIMA(X, Y, OTU, COV = NULL, FDPcut = 0.05, scale = TRUE)
}
\arguments{
\item{X}{a vector of exposure.}

\item{Y}{a vector of outcome.}

\item{OTU}{a \code{data.frame} or \code{matrix} of high-dimensional compositional OTUs (mediators). Rows represent samples, 
columns represent variables.}

\item{COV}{a \code{data.frame} or \code{matrix} of adjusting covariates. Rows represent samples, columns represent microbiome variables. 
Can be \code{NULL}.}

\item{FDPcut}{FDP (false discovery proportions) cutoff applied to define and select significant mediators. Default = \code{0.05}.}

\item{scale}{logical. Should the function scale the data? Default = \code{TRUE}.}
}
\value{
A data.frame containing mediation testing results of selected mediators (FDP < \code{FDPcut}). 
\itemize{
    \item{ID: }{index of selected significant mediator.}
    \item{alpha: }{coefficient estimates of exposure (X) --> mediators (M).}
    \item{alpha_se: }{standard error for alpha.}
    \item{beta: }{coefficient estimates of mediators (M) --> outcome (Y) (adjusted for exposure).}
    \item{beta_se: }{standard error for beta}
    \item{p_FDP: }{false discovery proportions of selected significant mediator.}
}
}
\description{
\code{microHIMA} is used to estimate and test high-dimensional mediation effects for compositional microbiome data.
}
\examples{
\dontrun{
data(Example4)
head(Example4$PhenoData)

microHIMA.fit <- microHIMA(X = Example4$PhenoData$Treatment, 
                           Y = Example4$PhenoData$Outcome, 
                           OTU = Example4$Mediator, 
                           COV = Example4$PhenoData[, c("Sex", "Age")],
                           scale = FALSE)
microHIMA.fit
}

}
\references{
Zhang H, Chen J, Feng Y, Wang C, Li H, Liu L. Mediation effect selection in high-dimensional and compositional microbiome data. 
Stat Med. 2021. DOI: 10.1002/sim.8808. PMID: 33205470; PMCID: PMC7855955.

Zhang H, Chen J, Li Z, Liu L. Testing for mediation effect with application to human microbiome data. 
Stat Biosci. 2021. DOI: 10.1007/s12561-019-09253-3. PMID: 34093887; PMCID: PMC8177450.
}
