% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessoryFunctions.R
\name{verifyAllele}
\alias{verifyAllele}
\title{Determine if an Allele Name Ever Existed, and (if so) its Most Recent IPD-IMGT/HLA Database Release}
\usage{
verifyAllele(allele, version = FALSE)
}
\arguments{
\item{allele}{A character string of an HLA allele name. Colon-delimited and field-delimited names are both accepted.}

\item{version}{A logical that indicates if the most recent nomenclature release version in which that name was valid should be returned.}
}
\value{
A logical identifying if the allele name is found in AlleleListHistory (TRUE) or not (FALSE), or c(TRUE,version) if version = TRUE.
}
\description{
Returns TRUE if an allele name is present in AlleleListHistory or FALSE it is absent, or c(TRUE,version), where 'version' is the most recent IPD-IMGT/HLA Database release in which that name appeared, when version = TRUE.
}
\examples{
verifyAllele("A*01:01:01:01")
verifyAllele("A*01:01:01:01",TRUE)
verifyAllele("A*010101",TRUE)
verifyAllele("A*0101",TRUE)

}
