% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BDtoPyPop.R
\name{BDtoPyPop}
\alias{BDtoPyPop}
\title{Convert BIGDAWG datasets to PyPop datasets

Converts a BIGDAWG-formatted data frame into a pair of PyPop-formatted case and control data frames.}
\usage{
BDtoPyPop(dataset, filename, save.file = TRUE, save.path = tempdir())
}
\arguments{
\item{dataset}{A data frame containing a BIGDAWG-formatted case-control dataset}

\item{filename}{A character string identifying the desired path and name for the generated files or the elements of the returned list object.}

\item{save.file}{A logical that determines if a pair of files should be written (TRUE) or if a list object should be returned. The default value is TRUE.}

\item{save.path}{A character string identifying the path in which to write the pair of files when save.file is TRUE. The default value is tempdir().}
}
\value{
When save.file = TRUE, a pair of files named "'filename'.positive.pop" and "'filename'.negative.pop" are generated in the working directory. When save.file = FALSE, a list of two-elements, named "'filename'.positive" and "'filename'.negative", is returned.
}
\description{
Convert BIGDAWG datasets to PyPop datasets

Converts a BIGDAWG-formatted data frame into a pair of PyPop-formatted case and control data frames.
}
\note{
Files generated by BDtoPyPop are intended for analysis using Pypop version 1.#.#. PyPop is not an R package, and must be installed separately.
}
\examples{
HLAdata.PP <- BDtoPyPop(sHLAdata,"BDHLA",FALSE)

}
\references{
Lancaster et al. Front Immunol. 2024 Apr 2;15:1378512. https://pubmed.ncbi.nlm.nih.gov/38629078/

Pappas et al. Hum Immunol. 2016 Mar 77(3):283-287. https://pubmed.ncbi.nlm.nih.gov/26708359/
}
