% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SearchandBuildAlignments.R
\name{queryPositions}
\alias{queryPositions}
\title{Extract Variant Information for Specific Positions in an Alignment}
\usage{
queryPositions(alignType, locus, positions, table = FALSE)
}
\arguments{
\item{alignType}{The type of alignment being searched. Allowed values are "prot", codon", "nuc" and "gen".  Only one 'alignType' value is allowed.}

\item{locus}{A locus supported by the IPD-IMGT/HLA Database.}

\item{positions}{A vector of numeric variant positions.}

\item{table}{A logical value specifying if a table of counts and frequencies for each variant at each value of 'positions' should be returned (table = TRUE). The default value is FALSE.}
}
\value{
When 'positions' specifies a single position, a character vector of variants is returned. When multiple positions are specified, a list of such character vectors is returned. When 'table' is TRUE, a list of data frames identifying the number (Count) and frequency (Frequency) of each variant is returned.
}
\description{
Identifies the sequence variants at specific positions in specified alignments in HLAalignments. When 'table' is TRUE, data frames of counts and frequencies for each variant at each position are returned.
}
\note{
This function requires that the HLAalignments object has been populated with alignments via the alignmentFull() function.

The '.' value in a vector of positions identifies absent sequence; e.g. following a nonsense mutation or in a region of sequence aligned to an insertion. The '*' value in a vector of positions identifies unknown sequence.
}
\examples{
\dontrun{
queryPositions("prot","DRB1",c(5,10,86,129))
queryPositions("prot","DRB1",c(5,10,86,129),TRUE)
}

}
