% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2.R
\name{plot.HRM}
\alias{plot.HRM}
\title{Plotting Profile Curves}
\usage{
\method{plot}{HRM}(x, xlab = "time", ylab = "mean", legend = TRUE,
  legend.title = "", ...)
}
\arguments{
\item{x}{An object of class 'HRM' from the function 'hrm.test'}

\item{xlab}{label of the x-axis of the plot}

\item{ylab}{label of the y-axis of the plot}

\item{legend}{logical indicating if a legend should be plotted}

\item{legend.title}{title of the legend}

\item{...}{Further arguments passed to the 'plot' function}
}
\description{
Plotting profile curves for up to one whole- or subplot-factor
}
\examples{
data(EEG)
head(EEG)

# plots profiles according to groups with
# subplot-factor called dimension

# first create an HRM object
object_hrm <- hrm_test(value ~ group*dimension, subject = "subject", data = EEG)

# plot the HRM object, here we use the additional argument 'theme_bw()' for ggplot2
plot(object_hrm, legend = TRUE, legend.title = "Group", ... =  theme_bw() )

# same plot without a legend
# note that 'theme_bw' overwrites the standard legend properties of plot.HRM
plot(object_hrm, ... =  theme_bw() +
  theme(legend.title = element_blank(), legend.position="none") )
}
\keyword{export}
