% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qPCR.R
\name{qPCR_sim}
\alias{qPCR_sim}
\title{Simulate qPCR values}
\usage{
qPCR_sim(physeq, control_mean_fun, control_sd_fun, treat_mean_fun, treat_sd_fun,
  n_tech_rep = 3, control_expr = NULL)
}
\arguments{
\item{physeq}{Object of class "phyloseq"}

\item{control_mean_fun}{Function used for simulating the qPCR normal distribution mean
for control samples.}

\item{control_sd_fun}{Function used for simulating the qPCR normal distribution
standard deviation for control samples.}

\item{treat_mean_fun}{Function used for simulating the qPCR normal distribution mean
for treatment samples.}

\item{treat_sd_fun}{Function used for simulating the qPCR normal distribution
standard deviation for treatment samples.}

\item{n_tech_rep}{Number of technical replicates.}

\item{control_expr}{Expression used to identify control samples based on sample_data.}
}
\value{
data.frame of qPCR values
}
\description{
qPCR values will be simulated for each sample in the provided phyloseq object.
The error distribution for each sample is drawn from a Gaussian distribution,
where the mean and standard deviation of the Gaussian distribution are set by
user-defined functions. The user-defined functions that take buoyant density
as input and returns a numeric value (see examples), which allows the qPCR
values to increase in mean & variance at certain buoyant densities.
}
\examples{
# making functions for simulating values
## 'x' will be Buoyant_density as defined in the phyloseq object sample_data
control_mean_fun = function(x) dnorm(x, mean=1.70, sd=0.01) * 1e8
## This will set sd to scale with the mean
control_sd_fun = function(x) control_mean_fun(x) / 3
## This will 'shift' the gene copy distribution to 'heavier' BDs
treat_mean_fun = function(x) dnorm(x, mean=1.75, sd=0.01) * 1e8
treat_sd_fun = function(x) treat_mean_fun(x) / 3
# simulating qPCR values
df_qPCR = qPCR_sim(physeq_S2D2,
                control_expr='Substrate=="12C-Con"',
                control_mean_fun=control_mean_fun,
                control_sd_fun=control_sd_fun,
                treat_mean_fun=treat_mean_fun,
                treat_sd_fun=treat_sd_fun)

# using the Cauchy distribution instead of normal distributions
control_mean_fun = function(x) dcauchy(x, location=1.70, scale=0.01) * 1e8
control_sd_fun = function(x) control_mean_fun(x) / 3
treat_mean_fun = function(x) dcauchy(x, location=1.74, scale=0.01) * 1e8
treat_sd_fun = function(x) treat_mean_fun(x) / 3
# simulating qPCR values
df_qPCR = qPCR_sim(physeq_S2D2,
                control_expr='Substrate=="12C-Con"',
                control_mean_fun=control_mean_fun,
                control_sd_fun=control_sd_fun,
                treat_mean_fun=treat_mean_fun,
                treat_sd_fun=treat_sd_fun)

}

