## ----setup, warning = FALSE, include = FALSE----------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  out.width = "auto",
  out.height = "480px",
  fig.width = 7,
  fig.height = 5,
  fig.align = "center",
  fig.retina = 1,
  dpi = 150,
  tangle = TRUE,
  eval=TRUE
)

## ----predictlayer_flow,echo=FALSE,warning=FALSE,fig.show='hold',message=FALSE,fig.cap='Figure 1:  Heatmap Visualization of a Torus with 500 Cells'----
knitr::include_graphics('./pngs/torus2.png')

## ----eval=TRUE, echo=FALSE----------------------------------------------------
library(knitr)
library(kableExtra)
# Create a data frame with hyperlinks
vignette_data <- data.frame(
  Version_Number = c("v18.05.17", "v18.05.17", "v23.05.16", "v23.10.26", "v24.05.16","v24.08.14", "v25.01.01"),
  Vignette_Title = c(
  "<a href='https://nbviewer.org/github/Mu-Sigma/HVT/blob/master/vignettes/HVT_vignette.html' target='_blank'>HVT Vignette</a>",
  "<a href='https://nbviewer.org/github/Mu-Sigma/HVT/blob/master/vignettes/HVT_model_diagnostics_vignette.html' target='_blank'>HVT Model Diagnostics Vignette</a>",
  "<a href='https://nbviewer.org/github/Mu-Sigma/HVT/blob/master/vignettes/Scoring_Cells_with_Layers_using_scoreLayeredHVT.html' target='_blank'>HVT Scoring Cells with Layers using scoreLayeredHVT</a>",
  "<a href='https://nbviewer.org/github/Mu-Sigma/HVT/blob/master/vignettes/HVT_Temporal_Analysis.html' target='_blank'>Temporal Analysis and Visualization: Leveraging Time Series Capabilities in HVT</a>",
  "<a href='https://nbviewer.org/github/Mu-Sigma/HVT/blob/master/vignettes/LLM_Embeddings_in_HVT.html' target='_blank'>Visualizing LLM Embeddings using HVT</a>",
  "<a href='https://nbviewer.org/github/Mu-Sigma/HVT/blob/master/vignettes/Implementation_of_tsne_umap_in_trainHVT.html' target='_blank'>Implementation of t-SNE and UMAP in trainHVT function</a>",
  "<a href='https://nbviewer.org/github/Mu-Sigma/HVT/blob/master/vignettes/Dynamic_Forecasting_macroeconomic_data.html' target='_blank'>Dynamic Forecasting of Macroeconomic Time Series Dataset using HVT</a>"
),
  Description = c(
    "Contains descriptions of the functions used for vector quantization and construction of Hierarchical Voronoi Tessellations for data analysis.",
    "Contains descriptions of functions used to perform model diagnostics and validation for the HVT model.",
    "Contains descriptions of the functions used for scoring cells with layers based on a sequence of maps using scoreLayeredHVT.",
    "Contains descriptions of the functions used for analyzing time series data and its flow maps.",
    "Contains the implementation and analysis of hierarchical clustering using the `clustHVT` function to evaluate and visualize token embeddings generated by OpenAI.",
    "Contains enhancements to the `trainHVT` function with advanced dimensionality reduction techniques such as  t-SNE and UMAP, and includes a table of evaluation metrics to improve analysis, visualization, and interpretability.",
    "Contains enhancements to the HVT package for dynamic forecasting using Monte Carlo Simulations of Markov Chain (MSM) on macroeconomic time series dataset."
  ),
  stringsAsFactors = FALSE
)
 
# Generate the table
kable(vignette_data, format = "html", 
      col.names = c("Version", "Vignette Title", "Description"), 
      align = "l", escape = FALSE) %>% 
  kable_styling(full_width = TRUE) %>% column_spec(1, width = "15%") 

## ----mlayer_flow,echo=FALSE,warning=FALSE,fig.show='hold',message=FALSE,fig.cap='Figure 2: Data Segregation for scoring based on a sequence of maps using scoreLayeredHVT()'----
knitr::include_graphics('./pngs/scoreLayeredHVT_function.png')

