% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_HypeGeoData.R
\name{merge}
\alias{merge}
\alias{merge.HypeGeoData}
\title{Merge HypeGeoData object}
\usage{
\method{merge}{HypeGeoData}(x, y, all.x = TRUE, sort = NA, ...)
}
\arguments{
\item{x}{\code{\link{HypeGeoData}} data frame, HYPE GeoData table to be extended with new columns.}

\item{y}{Data frame, with mandatory \code{SUBID} column.}

\item{all.x}{Logical, keep all rows from \code{x}. Defaults to \code{TRUE}, as opposed to default method, thus extending the GeData
table with columns in \code{y}.}

\item{sort}{Logical, result sorting by \code{by} columns. In addition to the default method's choices \code{TRUE, FALSE}, a third
option \code{NA} (default) will use sorting of \code{x} for results. I.e. a sorted GeoData table will be runnable in HYPE even after
merging.}

\item{...}{Arguments passed to S3 method for data frames, see \code{\link[base]{merge}} and Details.}
}
\value{
A \code{HypeGeoData} data frame.
}
\description{
Merge an imported HYPE GeoData table of class \code{link{HypeGeoData}} with another data frame.
}
\details{
\code{merge.HypeGeoData} allows to merge new columns to an existing HYPE GeoData table, while preserving the \code{HypeGeoData}
class attribute. Duplicate columns are marked with a \code{".y"}-suffix for the merged \code{y} data frame.

The following arguments of the default method are hard-coded:

\itemize{
\item{\code{by, by.x, by.y}, set to \code{"SUBID"}}
\item{\code{suffixes}, set to \code{c("", ".y")}}
}

The method warns if any of these arguments is supplied by the user. To override, use the GeoData table as argument \code{y} or
call the data frame method explicitly (\code{merge.data.frame()}).
}
\examples{
# import and create dummy data
te1 <- ReadGeoData(filename = system.file("demo_model",
"GeoData.txt", package = "HYPEtools"))
te2 <- data.frame(SUBID = sample(x = te1$SUBID, size = 10),
loc_vol = runif(n = 10, 10, 50))
merge(x = te1, y = te2)

}
\seealso{
\code{\link[base]{merge}}, the S3 generic function.
}
