% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_hdx.R
\name{read_hdx}
\alias{read_hdx}
\title{Read HDX-MS data file}
\usage{
read_hdx(filename)
}
\arguments{
\item{filename}{a file supplied by the user. Formats allowed: .csv, .xlsx and .xls.}
}
\value{
\code{dat} - a \code{\link{data.frame}} with validated content.
}
\description{
Imports data from a HDX-MS file and validates its content.
}
\details{
First version accepts files produced by DynamX 3.0 and 2.0 in basic format. 
The function checks if all necessary columns are provided in correct format.
}
\examples{
# read example data
head(read_hdx(system.file(package = "HaDeX", 
                     "HaDeX/data/KD_180110_CD160_HVEM.csv")))

}
\seealso{
\code{\link{calculate_kinetics}} \code{\link{calculate_state_deuteration}} \code{\link{plot_coverage}} \code{\link{plot_position_frequency}}
\code{\link{prepare_dataset}} \code{\link{quality_control}} \code{\link{reconstruct_sequence}}
}
