% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sun.info.R
\name{sun.info}
\alias{sun.info}
\title{Estimate the time of sun rise and set according to longitude, latitude and date}
\usage{
sun.info(date, latitude, longitude)
}
\arguments{
\item{date}{A vector with the time at which temperatures are recorded}

\item{latitude}{The latitude at which estimate the time}

\item{longitude}{The longitude at which estimate the time}
}
\value{
A vector with daily time length
}
\description{
Estimate the daily length according to latitude and date\cr
Based on Teets, D.A. 2003. Predicting sunrise and sunset times. The College Mathematics Journal 34(4):317-321.\cr
Can be compared with the function sunrise.set() of package StreamMetabolism
}
\details{
daily.length estimate the daily length according to latitude and date
}
\examples{
\dontrun{
# Generate a timeserie of time
date <- seq(from=as.Date("2000-01-01"), to=as.Date("2000-12-31"), by="1 day")
plot(date, sun.info(date, latitude=23, longitude=0)$day.length, bty="n",
 las=1, type="l", xlab="Ordinal days", ylab="Day length in hours")
plot(date, sun.info(date, latitude=23, longitude=0)$sunrise, bty="n",
 las=1, type="l", xlab="Ordinal days", ylab="Sun rise in hours")
}
}
\author{
Marc Girondot
}

