% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moon.info.R
\name{moon.info}
\alias{moon.info}
\title{Moon phase based on a date}
\usage{
moon.info(date = Sys.Date(), phase = FALSE)
}
\arguments{
\item{date}{A date in class Date. By default, it will use today date}

\item{phase}{If TRUE, a vector of characters with NM, FQ, FL LQ will be returned}
}
\value{
Return a value describing the moon phase:\cr
0 and 100 are full moon, 50 is new moon, 25 last quarter and 75 first quater
}
\description{
The script gives an index (base 100) that represents moon phase.\cr
If the return value (from 0 to 100) is between:\cr
0 and 1.6931595 or 98.3068405 and 100, it is full moon,\cr
23.3068405 and 26.6931595, last quarter,\cr
48.3068405 and 51.6931595, new moon,\cr	
73.3068405 and 76.6931595, first quarter\cr
When phase is set to TRUE, a character representing the moon phase is returned.
}
\details{
moon.info calculates the moon phase based on a date.
}
\examples{
\dontrun{
library("HelpersMG")
moon.info(as.Date("2001-12-31"))
moon.info(as.Date("14/04/2010", "\%d/\%m/\%Y"))
moon.info(as.Date("22/06/07", "\%d/\%m/\%y"))
moon.info(seq(from=as.Date("2012-03-01"), 
	to=as.Date("2012-04-15"), by="days"))
moon.info(seq(from=as.Date("2012-03-01"), 
		to=as.Date("2012-04-15"), by="days"), phase=TRUE)
}
}
\seealso{
Other Periodic patterns of indices: \code{\link{index.periodic}},
  \code{\link{minmax.periodic}}, \code{\link{sun.info}},
  \code{\link{tide.info}}
}
\author{
Marc Girondot \email{marc.girondot@u-psud.fr}
}
\keyword{Lunar}
\keyword{Lune}
\keyword{Moon}
