% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qvlmer.R
\name{qvlmer}
\alias{qvlmer}
\title{Quasi Variances for lmer Model Coefficients}
\usage{
qvlmer(object, factorname = NULL, coef.indices = NULL,
  dispersion = NULL, ...)
}
\arguments{
\item{object}{A object obtained using lmer from package lme4}

\item{factorname}{Either NULL, or a character vector of length 1}

\item{coef.indices}{Either NULL, or a numeric vector of length at least 3}

\item{dispersion}{An optional scalar multiplier for the covariance matrix, to cope with overdispersion for example}

\item{...}{Other arguments to pass to qvcalc.default}
}
\value{
A list of class qv.
}
\description{
Computes a set of quasi variances (and corresponding quasi standard errors) 
for estimated model coefficients relating to the levels of a categorical (i.e., factor) 
explanatory variable. For details of the method see Firth (2000), Firth (2003) or Firth 
and de Menezes (2004). Quasi variances generalize and improve the accuracy of “floating 
absolute risk” (Easton et al., 1991). This device for economical model summary was first 
suggested by Ridout (1989).\cr
Modified from qvcalc.lm() of packages qvcalc by David Firth, d.firth@warwick.ac.uk
}
\details{
qvlmer is Quasi Variances for lmer Model Coefficients
}
\examples{
\dontrun{
x <- rnorm(100)
y <- rnorm(100)
G <- as.factor(sample(c("A", "B", "C", "D"), 100, replace = TRUE))
R <- as.factor(rep(1:25, 4))
library(lme4)
m <- lmer(y ~ x + G + (1 | R))
qvlmer(m, factorname="G")
}
}
\references{
Easton, D. F, Peto, J. and Babiker, A. G. A. G. (1991) Floating absolute risk: an alternative to relative risk in survival and case-control analysis avoiding an arbitrary reference group. Statistics in Medicine 10, 1025–1035.

Firth, D. (2000) Quasi-variances in Xlisp-Stat and on the web. Journal of Statistical Software 5.4, 1–13. At http://www.jstatsoft.org

Firth, D. (2003) Overcoming the reference category problem in the presentation of statistical models. Sociological Methodology 33, 1–18.

Firth, D. and de Mezezes, R. X. (2004) Quasi-variances. Biometrika 91, 65–80.

McCullagh, P. and Nelder, J. A. (1989) Generalized Linear Models. London: Chapman and Hall.

Menezes, R. X. de (1999) More useful standard errors for group and factor effects in generalized linear models. D.Phil. Thesis, Department of Statistics, University of Oxford.

Ridout, M.S. (1989). Summarizing the results of fitting generalized linear models to data from designed experiments. In: Statistical Modelling: Proceedings of GLIM89 and the 4th International Workshop on Statistical Modelling held in Trento, Italy, July 17–21, 1989 (A. Decarli et al., eds.), pp 262–269. New York: Springer.
}
\author{
marc.girondot@u-psud.fr
}
