% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEfromHessian.R
\name{SEfromHessian}
\alias{SEfromHessian}
\title{Standard error of parameters based on Hessian matrix}
\usage{
SEfromHessian(a, hessian = FALSE, silent = FALSE)
}
\arguments{
\item{a}{An Hessian matrix}

\item{hessian}{If TRUE, return a list with the hessian and SE}

\item{silent}{If TRUE, report some problems}
}
\value{
SEfromHessian returns a vector with standard errors
}
\description{
Standard error of parameters based on Hessian matrix.\cr
The strategy is as follow:\cr
First it tries to inverse the Hessian matrix. If it fails, it uses the near
positive definite matrix of the Hessian.\cr
So now the inverse of the Hessian matrix can be computed.\cr
The diagonal of the inverse of the Hessian matrix is calculated. If all values are positive,
the SEs are the square root of the inverse of the Hessian.\cr
If not all values are positive, it will estimate the pseudo-variance
matrix based on Gill & King (2004). It necessitates a Cholesky matrix.\cr
If from some reason it fails (for example all SE are 0 in output), then the strategy of
Rebonato and Jackel (2000) will be used to generate the Cholesky matrix.
}
\details{
SEfromHessian returns standard error of parameters based on Hessian matrix
}
\examples{
\dontrun{
val=rnorm(100, mean=20, sd=5)
# Return -ln L of values in val in Gaussian distribution with mean and sd in par
fitnorm<-function(par, val) {
  -sum(dnorm(val, par["mean"], par["sd"], log = TRUE))
}
# Initial values for search
p<-c(mean=20, sd=5)
# fit the model
result <- optim(par=p, fn=fitnorm, val=val, method="BFGS", hessian=TRUE)
SE <- SEfromHessian(result$hessian)
library(MASS)
fitdistr(val, densfun = "normal")
}
}
\references{
Gill J. and G. King 2004. What to do when your Hessian is not invertible:
Alternatives to model respecification in nonlinear estimation. Sociological Methods
& Research 33: 54-87.

Rebonato and Jackel, “The most general methodology for creating a valid
correlation matrix for risk management and option pricing purposes”, Journal of Risk,
Vol 2, No 2, 2000.
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
