% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeriTools.R
\name{getReadMatrix.NB}
\alias{getReadMatrix.NB}
\title{Simulate a count matrix from negative binomial mixed effect models (NBMM).}
\usage{
getReadMatrix.NB(vec.num.rep, alphas, sigma2s, phis)
}
\arguments{
\item{vec.num.rep}{A vector of replicate numbers for each strain.}

\item{alphas}{Intercept vector \eqn{\alpha_g}'s, 
\eqn{1 \times \texttt{num.features}}{1 x num.features}.}

\item{sigma2s}{Random effect variance vector \eqn{\sigma^2_g}'s, 
\eqn{1 \times \texttt{num.features}}{1 x num.features}.}

\item{phis}{Dispersion parameter in NB models, \eqn{\phi_g}'s, a
\eqn{1 \times \texttt{num.features}}{1 x num.features} vector.}
}
\value{
A \eqn{G \times N}{G x N} matrix with NB reads. \eqn{N} is the 
  total number of samples; \eqn{G} is the number of features. Column names 
  are sample names of the form "Ss_r", where S stands for sample, s is the 
  strain number, r is the replicate number within the strain. Row names 
  are the feature names of the form "Gene g", where g is the feature index.
}
\description{
Simulate a (possibly unbalanced) count matrix from NBMM.
Under NBMM, an observed number of reads aligned to feature/gene \eqn{g}, 
\eqn{Y_{gsr}}, follows a negative binomial (NB) distribution with mean 
\eqn{\mu_{gs}} and variance \eqn{\mu_{gs}+\phi_{g} \mu_{gs}^2}, where 
\eqn{\phi_g} is the dispersion parameter, shared across strains. The 
generalized linear model uses a \eqn{\log}-link:\cr
 \eqn{\log(\mu_{gs}) = \alpha_g+ b_{gs}, \;\;b_{gs}\sim N(0, \sigma^2_g).}
}
\examples{
## Generate a sequencing dataset with 5 features and 6 strains. 
## Assign parameter values.
rep.num <- c(3, 5, 2, 3, 4, 2)
a0s <- c(-1, 1, 2, 5, 10)
sig2s <- c(10, 0.2, 0.1, 0.03, 0.01)
phis <- c(0.5, 1, 0.05, 0.01, 0.1)

set.seed(1234)
## Generate reads:
nbData <- getReadMatrix.NB(rep.num, a0s, sig2s, phis)
}
