% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EvaluatePairsFromXCMSSet.R
\name{EvaluatePairsFromXCMSSet}
\alias{EvaluatePairsFromXCMSSet}
\title{EvaluatePairsFromXCMSSet.}
\usage{
EvaluatePairsFromXCMSSet(xg = NULL, tp = NULL, gr = NULL, drt = 1,
  dmz = 0.025, mz_iso = 1.00335, n = 6, method = c("APCI",
  "ESI")[1], specific_row = NULL, testing = FALSE, silent = FALSE)
}
\arguments{
\item{xg}{xcmsSet object with group information.}

\item{tp}{Timepoint information for all samples (obviously required, internally converted to factor).}

\item{gr}{Group information for all samples, e.g. different genotypes or concentrations (optional, factor).}

\item{drt}{Allowed rt deviation in time units of xcmsSet (usually seconds) to test for candidates.}

\item{dmz}{Allowed mass deviation in Da.}

\item{mz_iso}{Mass defect of the isotope under investigation.}

\item{n}{Number of maximal incorporated carbons to test.}

\item{method}{Currently APCI or ESI. If APCI, dmz will be modified depending on n (see details).}

\item{specific_row}{A single row from groupval(xg) to process.}

\item{testing}{Stop in function using browser() if specific_row is specified; can be a isotope number, i.e. 3 will stop at third isotope.}

\item{silent}{Suppress warnings and console output if TRUE.}
}
\value{
A dataframe with all observable pairs within the provided xcmsSet peak list including mean group intensities and P values.
}
\description{
\code{EvaluatePairsFromXCMSSet} will analyze an xcmsSet result for mass pairs (mz1, mz2) with changes due to any 13C incorporation.
}
\details{
Using 'APCI' as method assumes that (i) you analyze TMS-derivatized compounds and (ii) your MS resolution does not allow to seperate Si and C isotopes
but reportes an intermediate mass as m/z. In this case you will find carbon isotopes below there expected masses, i.e. M+1 would be 1.001mDa apart from M+0 instead of 1.003.
The effect is increased with isotope number, i.e. M+6 will be ~20mDa below the expected value. Hence, selecting method 'APCI' will combine your selected dmz
with a allowed deviation due to Si-isotope caused mass shifts. Use 'ESI' if you are not sure if this effect takes place in your settings.
}
\examples{
#load grouped xcmsSet object (with 18 samples from 3 timepoints and 2 groups with 3 replicates each)
\donttest{
data(xg, package="HiResTEC")
data(sam, package="HiResTEC")
xcms_cand <- EvaluatePairsFromXCMSSet(xg=xg, tp=sam$TP, gr=sam$Group, drt=0.5, dmz=0.005)
head(xcms_cand[order(xcms_cand$P),])
}

}
