% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeWAIC.R
\name{computeWAIC}
\alias{computeWAIC}
\title{computeWAIC}
\usage{
computeWAIC(hM, ghN = 11, byColumn = FALSE)
}
\arguments{
\item{hM}{a fitted \code{Hmsc} model object}

\item{ghN}{order of Gauss-Hermite quadrature for approximate numerical integration}

\item{byColumn}{describes whether WAIC is computed for the entire model \code{byColumn=FALSE} or for each column (i.e. species) \code{byColumn=TRUE}}
}
\value{
the scalar WAIC
}
\description{
Computes the value of WAIC (Widely Applicable Information Criterion) for the \code{Hmsc} model
}
\details{
The result is exact for normal and probit observational models. For Poisson-type
observational model the result is obtained through numerical integration using Gauss-Hermite quadrature.
}
\examples{
# Compute WAIC of previously sampled Hmsc object
WAIC = computeWAIC(TD$m)


}
