% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testHostSwitch.R
\name{testHostSwitch}
\alias{testHostSwitch}
\title{Test for the significance of the difference between two difference of two
HostSwitch objects}
\usage{
testHostSwitch(
  simulated_quantities1,
  simulated_quantities2,
  parameter,
  test,
  warmup = NULL,
  plot = FALSE
)
}
\arguments{
\item{simulated_quantities1}{An object created by \code{\link[=simHostSwitch]{simHostSwitch()}}}

\item{simulated_quantities2}{An object created by \code{\link[=simHostSwitch]{simHostSwitch()}}}

\item{parameter}{Quantity of interest, possible values are:
\itemize{
\item "j" for total number of dispersing events (or \strong{j}umps)
\item "s" for total number of \strong{s}uccessful host switch events
\item "d" for \strong{d}istance between the pRes_sim and pRes_new_sim in
case of host switch
}}

\item{test}{Statistical test, available tests are:
\itemize{
\item ''t'' for \strong{t}-test (parametric)
\item ''w'' for \strong{W}ilcoxon-test (non-parametric)
}}

\item{warmup}{Number of warmup steps to be excluded when comparing models,
see details. Possible value are NULL (default) or
positive integer (min=1,max=50).}

\item{plot}{If \emph{TRUE}, a boxplot is drawn. Default = FALSE.}
}
\value{
An object of class testHostSwitch
}
\description{
Test for the significance of the difference between two difference of two
HostSwitch objects
}
\details{
This function tests the significance of the difference between
two objects generated by simHostSwitch function.
Warmup represents the initial condition that we want to exclude from the
test. The initial condition corresponds to the number of
generations (n_generations): warmup = 1 means that the generation at time 0
is excluded from comparison; warmup = 2 means generations at times 0 and 1
are excluded and so on.
If warmup = NULL all generations are considered for comparison, i.e. initial
condition is not considered.
}
\examples{
m1 = simHostSwitch(n_generations=100,n_sim=100)
m2 = simHostSwitch(n_generations=50,n_sim=50)
testHostSwitch(simulated_quantities1=m1,simulated_quantities2=m2,
parameter="j",test="t",plot=TRUE)
}
