% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeJagsModel.R
\name{writeJagsModel}
\alias{writeJagsModel}
\alias{writeJagsModel_default}
\alias{writeJagsModel_dbern}
\alias{writeJagsModel_dcat}
\alias{writeJagsModel_determ}
\alias{writeJagsModel_dnorm}
\alias{writeJagsModel_dnorm_default}
\alias{writeJagsModel_dpois}
\title{Write a Node's JAGS Model}
\usage{
writeJagsModel(network, node)

writeJagsModel_default(network, node_str, node_params)

writeJagsModel_dbern(network, node_str, node_params)

writeJagsModel_dcat(network, node_str, node_params)

writeJagsModel_determ(network, node_str, node_params)

writeJagsModel_dnorm(network, node_str, node_params)

writeJagsModel_dnorm_default(network, node_str, node_params)

writeJagsModel_dpois(network, node_str, node_params)
}
\arguments{
\item{network}{A network of class HydeNetwork}

\item{node}{A node within \code{network}}

\item{node_str}{A character string giving the name of a node within \code{network}.
This is usually generated within \code{writeJagsModel} and passed to 
a specific method.}

\item{node_params}{A vector of parameters for the node.  Generated by 
\code{writeJagsModel} and passed to a specific method.}
}
\description{
Constructs the JAGS code that designates the model for the 
  node conditioned on its parents.  The parameters for the model may 
  be user supplied or estimated from a given data set.
}
\details{
The manipulations are performed on the \code{nodeParams} element
  of the \code{Hyde} network.  A string of JAGS code is returned suitable
  for inclusion in the Bayesian analysis.  
  
  The function will (eventually) travel through a serious of \code{if} 
  statements until it finds the right node type.  It will then match
  the appropriate arguments to the inputs based on user supplied values or
  estimating them from the data.
}
\examples{
\dontrun{
#* NOTE: writeJagsModel isn't an exported function
data(PE, package='HydeNet')
Net <- HydeNetwork(~ wells + 
                     pe | wells + 
                     d.dimer | pregnant*pe + 
                     angio | pe + 
                     treat | d.dimer*angio + 
                     death | pe*treat,
                     data = PE)
HydeNet:::writeJagsModel(Net, 'pe')
HydeNet:::writeJagsModel(Net, 'treat')
}

}
\seealso{
\code{\link{writeJagsFormula}}
}
\author{
Jarrod Dalton and Benjamin Nutter
}
