% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foopTTable.R
\name{DpTcteTab}
\alias{DpTcteTab}
\title{Table of Densities, Function of Pressure for a Fixed Temperature}
\usage{
DpTcteTab(p1, p2, dp, T)
}
\arguments{
\item{p1}{first pressure value [ MPa ]}

\item{p2}{final pressure [ MPa ]}

\item{dp}{Pressure increment [ MPa ]}

\item{T}{Temperature [ K ]}
}
\value{
A table of Densities for fixed T and a p Interval: p1:p2.
}
\description{
The function \code{DpTcteTab(p1, p2, dp, T)} returns a table of 
    Densities [kg m-3] for a fixed T [K] within a range of p [MPa]: p1:p2 [MPa]
}
\details{
This function provides a table of the densities [kg m-3] for a given T [K] within a range of p [MPa]

This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
p1 <- 1.0
p2 <- 10.
dp <- 1.
T <- 500.
TabD <- DpTcteTab(p1, p2, dp, T)
TabD

p1 <- 10.
p2 <- 100.
dp <- 10.
T <- 450.
TabD <- DpTcteTab(p1, p2, dp, T)
TabD

}
