% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooDeriv.R
\name{dpdDTp}
\alias{dpdDTp}
\title{Pressure Derivative with respect to Density, Function of Temperature and Pressure}
\usage{
dpdDTp(T, p)
}
\arguments{
\item{T}{Temperature [ K ]}

\item{p}{Pressure [ MPa ]}
}
\value{
The pressure derivative with respect to d: dp/dD [ MPa kg-1 m3 ] and an Error
     Message (if an error occur: \link{errorCodes})
}
\description{
The function \code{dpdDTp(T,p)} returns the pressure derivative with 
    respect to Density, dpdD, for given T [K] and p [MPa].
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
T <- 500.
p <- 10.0003858
dpdD <- dpdDTp(T,p)
dpdD

}
