% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooHZ.R
\name{phi0DD}
\alias{phi0DD}
\title{Second Derivative of the Ideal-Gas Part of the Dimensionless Helmholtz Energy Equation
    with respect to Density, Function of Density}
\usage{
phi0DD(D, digits = 9)
}
\arguments{
\item{D}{Density [ kg m-3 ]}

\item{digits}{Digits of results (optional)}
}
\value{
The Second D Derivative of Ideal-gas part of the Helmholtz Energy: phi0DD and an Error
     Message (if an error occur: \link{errorCodes})
}
\description{
The function \code{phi0DD(D,digits=9)} returns the Second Derivative of the
    Ideal-gas part of the dimensionless Helmholtz Energy Equation for a given D [kg/m3].
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
D <- 838.025
phi_0 <- phi0DD(D)
phi_0

}
