% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{piecewise_x}
\alias{piecewise_x}
\title{Piecewise real function.}
\usage{
piecewise_x(breaks, funs)
}
\arguments{
\item{breaks}{Numeric vector giving the breaks of functions given in \code{funs}. Must be sorted with unique values.}

\item{funs}{List of functions.}
}
\value{
Piecewise function built with the given intervals and functions.
}
\description{
Given the vectors \verb{(breaks[1],...,breaks[n])} and the list of \code{IBMPopSim} compatible
functions \verb{funs = (f[0],f[1],...,f[n])} (one value more!), \code{piecewise_x(breaks, funs)} returns
the function
\deqn{f(x) = f_0(x){1}_{x\le breaks[1]}+\sum_{k=1}^{n-1} f_k(x) {1}_{[breaks_{k}, breaks_{k+1})}(x) + f_n(x){1}_{x \ge breaks[n]}}
}
\details{
A C++ version of this function is available. See \code{vignette('IBMPopSim_cpp')} for more details.
}
\examples{
dr <- with(EW_pop_14$rates,
           stepfun(x=death_male[,"age"], y=c(0,death_male[,"value"])))
# before age 80 the stepfun and after age 80 the gompertz function
f <- piecewise_x(80, list(dr, gompertz(0.00006, 0.085)))
x <- seq(40:120)
plot(x, sapply(x, f))

}
