% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pyramid.R
\name{plot_population}
\alias{plot_population}
\title{Plot the age pyramid of a population data frame (at a given time).}
\usage{
plot_population(
  population,
  group_colors,
  group_legend = "Group",
  age_breaks,
  value_breaks,
  ...
)
}
\arguments{
\item{population}{Population data frame, with at least \code{birth} and \code{death} column.}

\item{group_colors}{\emph{(Optional)} Named character vector.}

\item{group_legend}{\emph{(Optional)} Legend title name. By default set to \code{"Group"}.}

\item{age_breaks}{\emph{(Optional)} An ordered vector of indexes of vector \code{unique(pyr$age)} used for breaks for the axis of ages.}

\item{value_breaks}{\emph{(Optional)} Breaks for the axis of values.}

\item{...}{Other arguments passed to \code{\link{age_pyramid}} (including \code{time}).}
}
\value{
Plot of age pyramid.
}
\description{
Plot an age pyramid from age pyramid data frame with possibly several characteristics. See also \code{\link{plot_pyramid}} and \code{\link{age_pyramid}}.
}
\examples{
plot_population(EW_pop_14$sample, time = 0)

}
