% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INDELS_related_functions.R
\name{FindDelMH}
\alias{FindDelMH}
\title{Return the length of microhomology at a deletion.}
\usage{
FindDelMH(context, deleted.seq, pos, trace = 0)
}
\arguments{
\item{context}{The deleted sequence plus ample surrounding
sequence on each side (at least as long as \code{del.sequence}).}

\item{deleted.seq}{The deleted sequence in \code{context}.}

\item{pos}{The position of \code{del.sequence} in \code{context}.}

\item{trace}{If > 0, cat various messages.}
}
\value{
The length of the maximum microhomology of \code{del.sequence}
  in \code{context}.
}
\description{
Return the length of microhomology at a deletion.
}
\details{
This function is primarily for internal use, but we export it
to document the underlying logic.

Example:

\code{GGCTAGTT} aligned to \code{GGCTAGAACTAGTT} with
a deletion represented as:
\preformatted{

GGCTAGAACTAGTT
GG------CTAGTT GGCTAGTT GG[CTAGAA]CTAGTT
                           ----   ----
}

Presumed repair mechanism leading to this:

\preformatted{
  ....
GGCTAGAACTAGTT
CCGATCTTGATCAA

=>

  ....
GGCTAG      TT
CC      GATCAA
        ....

=>

GGCTAGTT
CCGATCAA

}

Variant-caller software can represent the
same deletion in several
different, but completely equivalent, ways.

\preformatted{

GGC------TAGTT GGCTAGTT GGC[TAGAAC]TAGTT
                          * ---  * ---

GGCT------AGTT GGCTAGTT GGCT[AGAACT]AGTT
                          ** --  ** --

GGCTA------GTT GGCTAGTT GGCTA[GAACTA]GTT
                          *** -  *** -

GGCTAG------TT GGCTAGTT GGCTAG[AACTAG]TT
                          ****   ****
}

A deletion in a \emph{repeat} can also be represented
in several different ways. A deletion in a repeat
is abstractly equivalent to microhomology that
spans the entire deleted sequence. For example;

\preformatted{
GACTAGCTAGTT
GACTA----GTT GACTAGTT GACTA[GCTA]GTT
                        *** -*** -
}

is really a repeat

\preformatted{
GACTAG----TT GACTAGTT GACTAG[CTAG]TT
                        **** ----

GACT----AGTT GACTAGTT GACT[AGCT]AGTT
                        ** --** --
}

\strong{This function only flags this
case with a -1 return; it does not figure
out the repeat extent.}

This function finds:

\enumerate{

\item The maximum match of undeleted sequence to the left
of the deletion that is
identical to the right end of the deleted sequence, and

\item The maximum match of undeleted sequence to the right
of the deletion that
is identical to the left end of the deleted sequence.
}

The microhomology sequence is the concatenation of items
(1) and (2).
}
\examples{
# GAGAGG[CTAGAA]CTAGTT
#        ----   ----
FindDelMH("GGAGAGGCTAGAACTAGTTAAAAA", "CTAGAA", 8, trace = 0)  # 4
}
