% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{ReadAndSplitMutectVCFs}
\alias{ReadAndSplitMutectVCFs}
\title{Read and split Mutect VCF files.}
\usage{
ReadAndSplitMutectVCFs(files)
}
\arguments{
\item{files}{Character vector of file paths to the Mutect VCF files.}
}
\value{
A list with 3 in-memory VCFs and two left-over
VCF-like data frames with rows that were not incorporated
into the first 3 VCFs, as follows:

\enumerate{

 \item \code{SBS} VCF with only single base substitutions.

 \item \code{DBS} VCF with only doublet base substitutions
  as called by Mutect.

 \item \code{ID} VCF with only small insertions and deletions.

 \item \code{other.subs} VCF like data.frame with
 rows for coordinate substitutions involving
 3 or more nucleotides, e.g. ACT > TGA or AACT > GGTA.

 \item \code{multiple.alternative.alleles} VCF like data.frame with
 rows for variants with multiple alternative alleles, for example
 ACT mutated to both AGT and ACT at the same position.

}
}
\description{
Read and split Mutect VCF files.
}
\examples{
file <- c(system.file("extdata",
                      "Mutect.GRCh37.vcf",
                      package = "ICAMS"))
list.of.vcfs <- ReadAndSplitMutectVCFs(file)
}
\seealso{
\code{\link{MutectVCFFilesToCatalog}}
}
