% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{ReadStrelkaSBSVCF}
\alias{ReadStrelkaSBSVCF}
\title{Read in the data lines of an SBS VCF created by Strelka version 1}
\usage{
ReadStrelkaSBSVCF(file, name.of.VCF = NULL)
}
\arguments{
\item{file}{The name/path of the VCF file, or a complete URL.}

\item{name.of.VCF}{Name of the VCF file. If \code{NULL}(default), this
function will remove all of the path up to and including the last path
separator (if any) in \code{file} and file path without extensions (and the
leading dot) will be used as the name of the VCF file.}

\item{suppress.discarded.variants.warnings}{Logical. Whether to suppress
warning messages showing information about the discarded variants. Default
is TRUE.}
}
\description{
Read in the data lines of an SBS VCF created by Strelka version 1
}
\section{Value}{
 A data frame storing data lines of a VCF file with two
  additional columns added which contain the VAF(variant allele frequency)
  and read depth information.
}

\keyword{internal}
