% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{AnnotateDBSVCF}
\alias{AnnotateDBSVCF}
\title{Add sequence context and transcript information to an in-memory DBS VCF}
\usage{
AnnotateDBSVCF(DBS.vcf, ref.genome, trans.ranges = NULL, name.of.VCF = NULL)
}
\arguments{
\item{DBS.vcf}{An in-memory DBS VCF as a \code{data.frame}.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{trans.ranges}{Optional. If \code{ref.genome} specifies one of the
\code{\link{BSgenome}} object
\enumerate{
  \item \code{BSgenome.Hsapiens.1000genomes.hs37d5}
  \item \code{BSgenome.Hsapiens.UCSC.hg38}
  \item \code{BSgenome.Mmusculus.UCSC.mm10}
}
then the function will infer \code{trans.ranges} automatically. Otherwise,
user will need to provide the necessary \code{trans.ranges}. Please refer to
\code{\link{TranscriptRanges}} for more details.
If \code{is.null(trans.ranges)} do not add transcript range
information.}

\item{name.of.VCF}{Name of the VCF file.}
}
\value{
An in-memory DBS VCF as a \code{data.table}. This has been annotated
  with the sequence context (column name \code{seq.21bases}) and with
  transcript information in the form of a gene symbol (e.g. \code{"TP53"})
  and transcript strand. This information is in the columns
  \code{trans.start.pos}, \code{trans.end.pos} , \code{trans.strand},
  \code{trans.Ensembl.gene.ID} and \code{trans.gene.symbol} in the output.
  These columns are not added if \code{is.null(trans.ranges)}.
}
\description{
Add sequence context and transcript information to an in-memory DBS VCF
}
\examples{
file <- c(system.file("extdata/Strelka-SBS-vcf",
                      "Strelka.SBS.GRCh37.s1.vcf",
                      package = "ICAMS"))
list.of.vcfs <- ReadAndSplitStrelkaSBSVCFs(file)
DBS.vcf <- list.of.vcfs$DBS.vcfs[[1]]
if (requireNamespace("BSgenome.Hsapiens.1000genomes.hs37d5", quietly = TRUE)) {
  annotated.DBS.vcf <- AnnotateDBSVCF(DBS.vcf, ref.genome = "hg19",
                                      trans.ranges = trans.ranges.GRCh37)}
}
