\name{ICEwedge}
\alias{ICEwedge}
\title{
 ICEwedge() functions calculate and display an Equivariant Wedge-Shaped Confidence
 Region with stated Statistical Confidence Level in the range: 0.50 <= conf <= 0.99.
}
\description{
 ICEwedge() uses the Bootstrap Distribution of ICE Uncertainty generated by ICEuncrt()
 to calculate and sort ICE Angle Order Statistics around a circle.  ICEwedge() then
 counts outwards the same number of ICE Angle Order Statistics, floor(R*conf/2), both
 Counter-Clockwise and Clockwise from the center Order Statistic (nearest the Observed
 ICE Ratio) to define a pair of ICE Ray Endpoints at Order Statistics jlo and kup
 that subtend an ICE Polar Angle of subangle degrees.
}
\usage{
ICEwedge(ICEu, lfact = 1, conf = 0.95)
}
\arguments{
  \item{ICEu}{Required; Output list object of class ICEuncrt.}
  \item{lfact}{Optional; Either a strictly positive multiplicative factor for ICEu item lambda
   or else 0 to cause ICEwedge to compute the positive lfact and lambda values which
   transforms the alibi display so that it has an alias interpretation.}
  \item{conf}{Optional; Statistical Confidence Level within [0.50, 0.99].}
}
\details{
 The plot() of an object of class ICEwedge displays the Bootstrap Distribution of ICE
 Uncertainty with a small, circular, colored dot (pch = 20).  Outcomes outside the Wedge
 are displayed in black, while outcomes inside the Wedge are displayed in cyan.  Upper
 and lower ICE Ray Limits are displayed as solid black lines, and the ICE Ray through
 the center ICE Angle Order Statistic is shown as a dashed black line.
}
\value{
  An object of class ICEwedge with the following output list:
  \item{ICEinp}{Name of the ICEuncrt object input to ICEwedge().}
  \item{lambda}{Positive value of lfact * ICEu item lambda}
  \item{lfact}{Positive Multiplier for the ICEu item lambda value input to ICEwedge().}  
  \item{unit}{Saved value of unit, cost or effe, input to ICEuncrt.}
  \item{conf}{Statistical Confidence Level within [0.50, 0.99] input to ICEwedge.}  
  \item{R}{Saved integer value for number of bootstrap replications input to ICEuncrt.}
  \item{axys}{R x 4 data.frame with ICE Angle in column 1, bootstrap resampled values of
   (DeltaEffe, DeltaCost) in columns 2 and 3, and the binary flag with 0 => outcome outSide the 
   Confidence Wedge and 1 => outcome inSide the Confidence Wedge in column 4.}  
  \item{t1}{Observed value of (DeltaEffe, DeltaCost) when each patient is sampled exactly once.}
  \item{ia1}{The center ICE Angle closest to the Objerved ICE Ratio.}
  \item{center}{The largest value of j such that axys[j, 1] < ia1 <= axys[j+1, 1].}
  \item{jlo}{Number of the ICE Angle Order Statistic defining the Clockwise or lower ICE Ray
   boundary of the Confidence Wedge.}
  \item{kup}{Number of the ICE Angle Order Statistic defining the Counter-Clockwise or upper
   ICE Ray boundary of the Confidence Wedge.}
  \item{subangle}{Subtended Polar ICE Angle between Order Statistics jlo and kup.}
  \item{xmax}{Alias plots of ICEwedge have horizontal range [-xmax, +xmax].}
  \item{ymax}{Alias plots of ICEwedge have vertical range [-ymax, +ymax].}
  \item{ab}{ICE angle computation perspective of alibi or alias.}
}
\references{
 Cook JR, Heyse JF.  Use of an angular transformation for ratio estimation in cost-effectiveness
 analysis.  \emph{Statistics in Medicine}  2000; \bold{19}: 2989--3003.
 
 Obenchain RL.  Resampling and multiplicity in cost-effectiveness inference.  \emph{Journal of
 Biopharmaceutical Statistics} 1999; \bold{9(4)}: 563--582.
 
 Obenchain RL.  ICE Preference Maps: Nonlinear Generalizations of Net Benefit and Acceptability.
 \emph{Lilly US Health Outcomes White Paper}.  2007; 52 pages.
 
 Obenchain RL.  \bold{ICEinR.pdf}  ../R\_HOME/library/ICEinfer  2007; 30 pages.
 
 Fan MY, Zhou XH.  A simulation study to compare methods for constructing confidence intervals
 for the incremental cost-effectiveness ratio.  \emph{Health Serv Outcomes Res Method}  2007;
 DOI 10.1007/s10742-006-0017-9.
}
\author{Bob Obenchain <softrx@iquest.net>}
\seealso{\code{\link{ICEuncrt}} and \code{\link{ICEcolor}}}
\examples{
  data(dpunc)
  # ICEwedge() calculations are rather slow
  dpwdg <- ICEwedge(dpunc)
  dpwdg
  plot(dpwdg)
  # ICE Angle computations using the alibi axes with an alias interpretation
  dpwdg0 <- ICEwedge(dpunc, lfact=0)
  dpwdg0
  plot(dpwdg0)
}
\keyword{methods}
\keyword{nonparametric}
\keyword{robust}