% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotForest.R
\name{PlotForest}
\alias{PlotForest}
\title{PlotForest}
\usage{
PlotForest(MiRNA_CRData,g.pos = 2,b.size = 3,col = c("#FE0101", "#1C61B6", "#A4A4A4"),
lwd.zero = 2,lwd.ci = 3,x.lab = "Hazard Ratio Plot")
}
\arguments{
\item{MiRNA_CRData}{A list includes a data frame with seven parts those are "sample", "status", "time", "target genes expression", "risk score", "group", and a data frame with five columns those are "Gene", "HR", "HR.95L", "HR.95H", "beta", and "P-value".}

\item{g.pos}{The position of the graph element within the table of text. The position can be 1-(ncol(labeltext) + 1). You can also choose set the position to "left" or "right".}

\item{b.size}{Override the default box size based on precision.}

\item{col}{Set the colors for all the elements in the plot.}

\item{lwd.zero}{lwd for the vertical line that gives the no-effect line, see gpar.}

\item{lwd.ci}{lwd for the confidence bands, see gpar.}

\item{x.lab}{x-axis label.}
}
\value{
Forest maps associated with the Cox risk model.
}
\description{
Function "PlotForest" can visualize the result of Cox regression analysis through forest plot.
}
\examples{
# Obtain the example data
GEP<-GetData_Mirna("GEP")
survival<-GetData_Mirna("survival")
MiRNAs<-c("hsa-miR-21-5p","hsa-miR-26a-5p","hsa-miR-369-5p","hsa-miR-1238-3p","hsa-miR-10b-5p")
# Run the function
SingleMiRNA_CRData<-SingleMiRNA_CRModel(GEP,
"hsa-miR-21-5p",survival,cutoff.point=NULL)
PlotForest(SingleMiRNA_CRData)
MutiMiRNA_CRData<-MutiMiRNA_CRModel(GEP,
MiRNAs,survival,cutoff.point=NULL)
PlotForest(MutiMiRNA_CRData)
}
