% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idsa.R
\name{idsa}
\alias{idsa}
\title{IDSA model with spatial discretization parameters.}
\usage{
idsa(formula, location, data, ndisc, methoddisc,
            methodoverlay = "fuzzyAND")
}
\arguments{
\item{formula}{A formula of spatial variables}

\item{location}{A character vector of location names in a data frame}

\item{data}{A data frame of dataset}

\item{ndisc}{A numeric vector of break numbers for respective
explanatory variables}

\item{methoddisc}{A character vector of discretization methods}

\item{methodoverlay}{A character of spatial overlay methods, including
"fuzzyAND" and "intersection"}
}
\value{
A list of IDSA results.
}
\description{
IDSA model with spatial discretization parameters.
}
\examples{
q.fand <- idsa(formula = y ~ xa + xb + xc, location = c("lo", "la"),
               data = sim, ndisc = c(4,6,6), methoddisc = "quantile",
               methodoverlay = "fuzzyAND")
q.ints <- idsa(formula = y ~ xa + xb + xc, location = c("lo", "la"),
               data = sim, ndisc = c(4,6,6), methoddisc = "quantile",
               methodoverlay = "intersection")

}
